##### Programming Python
##### 一个主 window 控制其他 windows

import tkinter as tk

root = tk.Tk() # explicit root
trees = [("The Larch!", "light blue"),
    ("The Pine!", "light green"),
    ("The Giant Redwood!", "red")]

for (tree, color) in trees:
    win = tk.Toplevel(root) # new window
    win.title("Sing...") # set border
    win.protocol("WM_DELETE_WINDOW", lambda:None) # ignore close

    msg = tk.Button(win, text=tree, command=win.destroy) # kills one win
    msg.grid(sticky=tk.E+tk.W)
    msg.config(padx=10, pady=10, bd=10, relief=tk.RAISED)
    msg.config(bg="black", fg=color, font=("times", 30, "bold italic"))

root.title("Open Windows")
tk.Label(root, text="Main window", width=30).grid()
tk.Button(root, text="Quit All", command=root.destroy).grid() # kills all app
root.mainloop()


    



