#### 使用选择框的简单程序
import tkinter as tk

class MixColor(tk.Frame):
    def __init__(self):
        tk.Frame.__init__(self)
        self.master.title("MixColor")
        self.grid()
        label = tk.Label(self, text="", width=30)
        label.grid(row=0, column=0, columnspan=3)
        
        red = tk.IntVar()
        green = tk.IntVar()
        blue = tk.IntVar()
        ilist = ((0,"Red",red), (1,"Green",green), (2,"Blue",blue))
        for i, name, var in ilist:
            color = tk.Checkbutton(self, text=name, variable=var)
            color.grid(row=1, column=i)
        button = tk.Button(self, text="update",
                      command=lambda:
                           self.update(label, red, green, blue))
        button.grid(row=2, column=0, columnspan=3)
        self.update(label, red, green, blue)

    def update(self, widget, r, g, b):
        color = "#"
        for var in (r, g, b):
            color += "FF" if var.get() else "00"
        widget["bg"] = color
        
MixColor().mainloop()
