## 一个构造输入项组的窗口定义

import tkinter as tk

class InputWin(tk.Frame):
    labels = ("姓名:", "年龄:", "出生地:")
    
    def __init__(self, parent=None, callback=lambda x:None):
        """Define a framed window.""" # 文档串
        tk.Frame.__init__(self, parent) # 初始化Frame实例

        self._callback = callback
        
        self.master.title("数据录入") # 设置窗口标题
        self.grid()# 安置本Frame

        frm = tk.Frame(self)
        frm.grid()
        self._varlist = []
        i = 0
        for title in InputWin.labels:
            v = self._build(frm, i, title)
            self._varlist.append(v)
            i += 1

        frm = tk.Frame(self, relief=tk.SUNKEN)
        frm.grid(sticky=tk.EW)
        but1 = tk.Button(frm, text="接受数据",
                         command=self._input_data)
        but1.grid(column=0, row=0, padx=20, pady=2)
        but2 = tk.Button(frm, text="结束输入",
                         command=self.master.destroy)
        but2.grid(column=1, row=0, padx=20, pady=2)


    def _build(self, frm, i, lname):
        label = tk.Label(frm, text=lname, anchor=tk.W)
        label.grid(row=i, column=0, sticky=tk.E+tk.W)
        v = tk.StringVar()
        entry = tk.Entry(frm, textvariable=v, justify=tk.RIGHT)
        entry.grid(row=i, column=1)
        return v

    def _input_data(self):
        self._callback([v.get() for v in self._varlist])
        for v in self._varlist: v.set("")

if __name__ == "__main__":
    InputWin(callback=print).mainloop()
    #InputWin().mainloop()
