# 本模块定义几个几何形状类
# 主要展示已经定义的类，可以用于定义新的类

class Point:
    def __init__(self, x, y):
        self._x = x
        self._y = y

    def getx(self):
        return self._x

    def gety(self):
        return self._y

    def area(self):
        return 0

    def move(self, delta_x, delta_y):
        self._x += delta_x
        self._y += delta_y
        
class Rectangle:
    def __init__(self, point, length, width):
        self._point = point
        self._length = length
        self._width = width

    def getx(self):
        return self._point.getx()
    
    def gety(self):
        return self._point.gety()

    def area(self):
        return self._length * self._width

    def move(self, delta_x, delta_y):
        self._point.move(delta_x, delta_y)

class ColoredRect(Rectangle):
    def __init__(self, point, length, width, color):
        Rectangle.__init__(self, point, length, width)
        self._color = color

    def set_color(self, color):
        self._color = color

    def get_color(self):
        return self._color

from math import pi

class Circle:
    def __init__(self, point, radius):
        self._center = point
        self._radius = radius

    def getx(self):
        return self._center.getx()
    
    def gety(self):
        return self._center.gety()

    def area(self):
        return self._radius**2 * pi

    def move(self, delta_x, delta_y):
        self._center.move(delta_x, delta_y)

def is_shape(x):
    return (isinstance(x, Point) or
            isinstance(x, Rectangle) or
            isinstance(x, Circle))

def area(slist):
    s = 0
    for x in slist:
        if is_shape(x):
            s += x.area()
    return s

if __name__ == "__main__":

    print("Point:")
    point1 = Point(2, 3)
    point2 = Point(5, 6)
    print(point1.getx(), point1.gety())

    point1.move(3, 7)
    print(point1.getx(), point1.gety())

    print(point1.area(), point2.area())

    print("Rectangle:")
    rect1 = Rectangle(Point(0, 0), 2, 3)
    rect2 = Rectangle(Point(7, 5), 5, 6)
    print(rect1.getx(), rect1.gety())

    rect1.move(3, 7)
    print(rect1.getx(), rect1.gety())

    print(rect1.area(), rect2.area())

    print("Circle:")
    circ1 = Circle(Point(0, 0), 3)
    circ2 = Circle(Point(7, 5), 6)
    print(circ1.getx(), circ1.gety())

    circ1.move(3, 7)
    print(circ1.getx(), circ1.gety())

    print(circ1.area(), circ2.area())

    print("Area:", area((circ1, rect1, rect2, point1)))



