# 定义一个简单的容器类

class Box:
    def __init__(self, elems=[]):
        self._elems = list(elems)
        
    def __len__(self):
        return len(self._elems)
    
    def __getitem__(self, ind):
        return self._elems[ind]
    
    def append(self, value):
        self._elems.append(value)
        
    def __setitem__(self, ind, value):
        self._elems[ind] = value
        
    def __contains__(self, item):
        return item in self._elems
    
    def __str__(self):
        return "Box" + str(self._elems)
    
    def __iter__(self):
        for x in self._elems:
            yield x

if __name__ == "__main__":
    b1 = Box()
    b1.append(1)
    b1.append(2)
    print(b1[0])
    b1[0] = 5
    print(b1[0])
    if 2 in b1:
        print(2, "is here.")

    for i in range(len(b1)):
        print(b1[i])

    for x in b1:
        print(x)

    print(b1)
