# 展示类装饰器的意义
# 这里定义一个简单的类装饰器，它给被装饰类增加实例计数功能

def add_counter(cls):
    cls.__objnum = 0 # 给类 cls 增加一个数据属性

    init = cls.__init__ # 取得原 __init__ 函数对象

    def tmp(*args, **kwargs): # 定义新版本的初始化函数
        init(*args, **kwargs)
        cls.__objnum += 1

    cls.__init__ = tmp # 设置新版本的初始化函数

    # 定义一个新的类函数，取对象计数值
    cls.objnum = classmethod(lambda cls: cls.__objnum)

    return cls
        
@add_counter
class Shape:
    def area(self):
        raise NotImplementedError

    def move(self, delta_x, delta_y):
        raise NotImplementedError

    def name(self): return "Shape"

    def show(self):
        print("I am a", self.name() +".",
              "My area is", self.area()) 

class Point(Shape):
    def __init__(self, x, y):
        Shape.__init__(self)
        self._x = x
        self._y = y

    def getx(self):
        return self._x

    def gety(self):
        return self._y

    def area(self):
        return 0

    def move(self, delta_x, delta_y):
        self._x += delta_x
        self._y += delta_y

    def name(self): return "Point"

class Rectangle(Shape):
    def __init__(self, point, length, width):
        Shape.__init__(self)
        self._point = point
        self._length = length
        self._width = width

    def getx(self):
        return self._point.getx()
    
    def gety(self):
        return self._point.gety()

    def area(self):
        return self._length * self._width

    def move(self, delta_x, delta_y):
        self._point.move(delta_x, delta_y)

    def name(self): return "Rectangle"


def area(slist):
    s = 0
    for x in slist:
        if isinstance(x, Shape):
            s += x.area()
    return s

if __name__ == "__main__":
    x = Point(2, 3)
    y = Rectangle(x, 3, 5)
    z = Rectangle(x, 6, 8)

    x.show()
    y.show()

    print("Total Area:", area([x, y, z]))

    print(Shape.objnum())

