####  一个简单的电话薄程序
## 电话薄的内存表示：联系人名 -> 联系人记录 的字典
##       联系人记录：域名 -> 域值 的字典
##
## 文件表示：一个联系人记录表示为一些行
##       第一行 name .....
##       其余的行均以域名开头，后跟该域的值（字符串）


def load_phonebook(infile):
    book = {}
    line = infile.readline()
    if line[:4] != "name":
        raise ValueError
    try:
        while True:
            name = line[5:].strip()
            book[name] = {} # create a dict for a person
            while True:
                line = infile.readline()
                if line == "": # file end
                    raise StopIteration
                if line == "\n": # blank line, skip
                    continue
                if line[:4] == "name": # add a field
                    break
                entry = line.split(maxsplit=1)
                book[name][entry[0]] = entry[1].strip()
    except StopIteration:
        pass

    return book

def save_phonebook(book, outfile):
    for name, record in book.items():
        outfile.write("name " + name + "\n")
        for field, value in record.items():
            outfile.write(field + " " + value + "\n")
        outfile.write("\n")


phonebook = None

def phone():
    if phonebook == None:
        print("Phonebook has not loaded.")
        return

    name = input("Name: ")
    try:
        print(phonebook[name]["phone"])
    except KeyError:
        print("No such name in the phonebook.")

def load():
    global phonebook
    try:
        infile = open(input("File name: ") + ".bok")
    except OSError as ex:
        print("File open error:", ex.args[1])
        return

    phonebook = load_phonebook(infile)
    infile.close()

def save():
    if phonebook == None:
        print("Phonebook has not loaded.")
        return

    try:
        outfile = open(input("File name: ") + ".bok", "w")
    except OSError as ex:
        print("File open error:", ex.args[1])
        return
    
    save_phonebook(phonebook, outfile)
    outfile.close()

def add():
    global phonebook
    try:
        name = input("Name: ")
        if name not in phonebook:
            phonebook[name] = {}
        number = input("Phone number: ")
        phonebook[name]["phone"] = number
        yesno = input("Other entry (yes/no)? ")
        if yesno.lower() != "yes":
            return
        print("Ehtry form: entry-name entry-value")
        print("Empty line to stop.")
        while True:
            line = input("Next entry: ")
            if line == "": # direct return then
                return
            entry = line.split(maxsplit=1)
            phonebook[name][entry[0]] = entry[1].strip()
    except Exception as ex:
        print("Input is not in correct form. Stop command add.")
        pass            


commands = {
    "load": (load, "load a phonebook file"),
    "save": (save, "save the phonebook into a file"),
    "phone": (phone, "search the telephone number for a name"),
    "add": (add, "add a contact or entries to an existing contact")
    }

from sys import argv

if len(argv) > 1:
    try:
        infile = open(argv[1] + ".bok")
    except OSError as ex:
        print("Commandline arg error:", argv[1] + ".", ex.args[1])
    else: # 正常打开文件后，装入电话簿
        phonebook = load_phonebook(infile)
        infile.close()
        del commands["load"]

print("""This is a phonebook program. Please type command:
quit: quit the program""")
for cmd, value in commands.items():
    print(cmd + ":", value[1])
if phonebook is None:
    print("Please load a phonebook before uses.")

while True:
    try:
        cmd = input("Command>> ")
        commands[cmd][0]()
    except KeyError:
        if cmd == "quit":
            if not phonebook:
                break
            yesno = input("Resave the phonebook (yes/no)? ")
            if yesno.lower() != "no":
                save()
            break
        else:
            print("No such command!")

print("Bye!")


    
