#### 采用马尔可夫链技术生成随机文本

## 字典 word_dict，关键码为 (w1, w2)，值为单词对 w1, w2 后继的表，可能重复
## 函数 build_dict 读入文件建立字典 word_dict
## 函数 generate 基于 word_dict 和原文中最前的两个单词 word1, word2
## 生成一段正文

from random import choice, seed

def get_words(fname):
    infile = open(fname)
    while True:
        line = infile.readline()
        if not line:  # end of file
            infile.close()
            return
        for s in line.split():
            yield s

def build_dic(fname):
    prefix = (" ", " ")
    word_dic = {}
    for word in get_words(fname):
        try:
            word_dic[prefix].append(word)
        except KeyError:
            word_dic[prefix] = [word]
        prefix = (prefix[1], word)
    
    return word_dic

def generate(outfile, word_dic, length):
    prefix = (" ", " ")
    seed()

    for i in range(length):
        try:
            word = choice(word_dic[prefix])
            outfile.write(word)
            prefix = (prefix[1], word)
            if i != length - 1:
                outfile.write(" ")
        except KeyError:
            return

# Main program
if __name__ == "__main__":
    from sys import stdout
    
    in_fname = input("Please give a file name: ")
    wdic = build_dic(in_fname)
    generate(stdout, wdic, 100)
