#### file summary.py 统计文件内容情况
## Facility for check data file(s)

def summary_datafile(fname):
    """fname is the name of a data file
    print numbers of floats and wrong-formated entries in file fname
    return the two numbers and summation of the floats in the form
    of a tuple (num, errnum, summation).
    """
    try:
        datafile = open(fname, errors="ignore")
    except OSError:
        print("File cannot open:", fname)
        raise # re-raise original OSError exception

    num = 0
    errnum = 0
    accum = 0.0

    for line in datafile:
        for w in line.split():
            try:
                x = float(w)
                accum += x
                num += 1
            except ValueError:
                errnum += 1
    datafile.close()

    print("In file " + fname + ":")
    print("Correct numbers:", num)
    print("Format error entries:", errnum)
    return (num, errnum, accum)


if __name__ == "__main__":
    num = 0
    errnum = 0
    accum = 0.0
    while True:
        fname = input("Next file name (None to quit): ")
        if fname == "None":
            print("Correct numbers:", num)
            print("Format error entries:", errnum)
            print("Accumulated value:", accum)
            break

        try:
            n, e, a = summary_datafile(fname)
            num += n
            errnum += e
            accum += a
        except OSError as msg:
            print("Details:", msg.args)
