## 统计一个Python程序里几类字符的个数

def count_file(fname):
    digits = letters = spaces = others = 0
    infile = open(fname, encoding="utf_8")
    for line in infile:
        for c in line:
            if c.isdigit():
                digits += 1
            elif c.isalpha():
                letters += 1
            elif c.isspace():
                spaces += 1
            else:
                others += 1
    infile.close()
    print("In the file, there are:")
    print("\t", digits, "digits;")
    print("\t", letters, "letters;")
    print("\t", spaces, "blank chars;")
    print("\t", others, "other chars.")

# 用 cnt_file("some-others.py") 试验
# 如果读入的文件里有中文，要看中文的编码格式，一般可以用
# infile = open(fname, encoding="utf_8") 打开文件
# 修改之后就可以处理 cnt_file("comp17-others2.py") 
