#### 求账单总计的函数
#### 账单用表表示，账单元素为 [单价, 数量]

def total0(invoice):
    assert isinstance(invoice, list)
    sum = 0.0
    for entry in invoice:
        sum += entry[0] * entry[1]
    return sum

#### 实际上, Python 中可以把程序写得更清晰，可以用两个变量
#### 分别获得账单表中各元素的两个项

def total(invoice):
    assert isinstance(invoice, list)
    sum = 0.0
    for price, quantity in invoice:
        sum += price * quantity
    return sum

inv1 = [[2.10, 12.4], [1.25, 2.44], [17.34, 3.6]]
print("Total price:", round(total(inv1), 2))

print("Total price: {:.2f}".format(total(inv1)))
