#### 用字典表示多项式，多项式运算：加法

def poly_num_times(a, p1):
    res = {}
    for d in p1:
        res[d] = p1[d] * a
    return res

def poly_plus(p1, p2):
    res = {}
    degrees = set(p1) | set(p2)
    for d in degrees:
        coeff = p1.get(d, 0) + p2.get(d, 0)
        if coeff != 0:
            res[d] = coeff
    return res

def poly_times(p1, p2):
    res = {}
    for d1 in p1:
        for d2 in p2:
            d = d1 + d2
            coeff = res.get(d, 0) + p1[d1] * p2[d2]
            if coeff == 0:
                if d in res:
                    del res[d]
            else:
                res[d] = coeff
    return res

def poly_equal(p1, p2):
    if len(p1) != len(p2):
        return False
    for d in p1:
        if p1.get(d, 0) != p2.get(d, 0):
            return False
    return True


poly1 = {0: 1, 1: -3, 10000: 2}
poly2 = {1: 3, 2: -2, 1000: 5, 10000: 6}
poly3 = {0: 1, 1: -1}
poly4 = {0: 1, 1: 1, 2: 1, 3: 1, 4: 1}

p3 = poly_plus(poly1, poly2)
p4 = poly_num_times(3, p3)
p5 = poly_times(poly1, poly2)

p6 = poly_times(p3, p4)
p7 = poly_times(p4, p3)

print(poly_equal(p6, p7))
print(poly_equal(p6, poly_num_times(2, p7)))

print(poly_times(poly3, poly4))


