#### 求包含斐波那契数列的表

def gen_fibs(n):
    fibs = [0] * (n + 1)
    fibs[1] = 1
    for i in range(2, n + 1):
        fibs[i] = fibs[i-2] + fibs[i-1]
    return fibs

fs = gen_fibs(20)
print("First {} Fibonacci numbers: {}".format(len(fs), fs))


#### 另一做法，逐项生成后用 append 方法加在表的最后

def gen_fibs1(n):
    fibs = [0, 1]
    for i in range(2, n + 1):
        fibs.append(fibs[-2] + fibs[-1])
    return fibs

fs = gen_fibs(20)
print("First {} Fibonacci numbers: {}".format(len(fs), fs))
