##### 在表中积累可能重用的信息，带有自动存储的技术
#### 求斐波那契序列值的递归函数的改进

def fib(n):
    fibs = [-1] * (n + 1)
    fibs[0] = 0
    fibs[1] = 1
    # 初始表，前两项是 fib(0) 和 fib(1)
    # 也可以写 fibs = [0, 1] + [-1] * (n-1)
    # 但后一做法多花了建立表的时间（共创建3个表）
    
    def fib0(k):
        if fibs[k] != -1:
            return fibs[k]
        fibs[k] = fib0(k-2) + fib0(k-1)
        return fibs[k]

    return fib0(n)
