### 利用多项式的 Horner 范式求多项式的值
### range(len(p)-1, -1, -1) 给出序列  
### len(p)-1, len(p)-2, ..., 2, 1, 0,
### 其中包括 0, 步长为 -1.

p1 = [1, 3, 3, 1]
p2 = [2, 5, 6, 2, 1]

def eval_poly2(p, x):
    val = 0.0
    for i in range(len(p)-1, -1, -1):
        val = val * x + p[i]
    return val

print("Value of p1 in 1.0:", eval_poly2(p1, 1.0))
print("Value of p2 in 2.7:", eval_poly2(p2, 2.7))


def eval_poly3(p, x):
    val = 0.0
    for a in reversed(p):
        val = val * x + a
    return val

print("Value of p1 in 1.0:", eval_poly3(p1, 1.0))
print("Value of p2 in 2.7:", eval_poly3(p2, 2.7))
