#### lambda 表达式的直接使用

##print((lambda x, y: x**2 + y**2)(3, 4))

#### 采用 lambda 表达式定义的求立方、求平方函数

def appr_method(x, improve, accept):
    if x == 0.0:
        return 0.0
    x1 = x
    while True:
        x2 = improve(x, x1)
        if accept(x1, x2):
            return x2
        x1 = x2
    return x2

def cbrt(x):
    return appr_method(x,
                       lambda x, x1:(2.0 * x1 + x / x1 / x1) / 3,
                       lambda x1, x2: abs((x2 - x1)/x1) < 1E-6)

def sqrt(x):
    return appr_method(x,
                       lambda x, x1:(x1 + x/x1)/2,
                       lambda x1, x2: abs((x2 - x1)/x1) < 1E-6)
