#### 求一个可积函数的数值积分，积分函数需要一个函数参数和一个积分区间
#### 设参数 f 被积函数, [a, b] 是积分区间

def integrate(f, a, b):
    def integ(f, a, b, division):
        d = (b - a)/division
        s = 0
        for i in range(division):
            s += f(a + i * d)
        return s * d

    div = 20
    x1 = integ(f, a, b, div)
    while True:
        div *= 2
        x2 = integ(f, a, b, div)
        if abs((x2 - x1) / x1) < 1E-6:
            return x2
        x1 = x2

from math import sin, cos, pi
print(integrate(sin, 0, pi))
print(integrate(sin, pi, 0))
print(integrate(cos, 0, pi/2))
