#### cbrt 的改造，将局部使用的函数放入主要函数内部，减少全局定义

def cbrt(x):
    def improve(x, guess):
        return (2.0 * guess + x / guess / guess) / 3
    
    def accept(guess, tmp):
        return abs((tmp - guess)/guess) < 1E-6

    if x == 0.0:
        return 0.0
    guess = x
    while True:
        tmp = improve(x, guess)
        if accept(guess, tmp):
            return tmp
        guess = tmp

cbrt(20.0)
